using System;
using System.IO;

namespace BTSServiceWindowsConditions
{
	/// <summary>
	/// This is a sample condition class. It contains a method that is checked as an enableCondition and
	/// another for the disableCondition. These methods can do whatever you want, the boolean return
	/// value tells BTSServiceWindows if it's OK to enable or disable a receive location. The class and method
	/// names can be whatever you want, and are specified in the configuration file that you
	/// tell BTSServiceWindows to use.
	/// </summary>
	public class Conditions
	{
		const string semaphorePath = @"C:\Visual Studio Projects\BTSServiceWindows\SampleConsoleApplication\"; 
		public bool EnableCondition()
		{
			return File.Exists(semaphorePath + "semaphore_enable.txt");
		}

		public bool DisableCondition()
		{
			return File.Exists(semaphorePath + "semaphore_disable.txt");
		}

	}
}
